<?php

defined('ABSPATH') or die('Plugin file cannot be accessed directly.');

class iat_general
{

    public $conn;
    public $wp_posts;
    public $wp_postmeta;

    public function __construct()
    {
        global $wpdb;
        $this->conn = $wpdb;
        $this->wp_posts = $this->conn->prefix . 'posts';
        $this->wp_postmeta = $this->conn->prefix . 'postmeta';
        add_action('admin_menu', array($this, 'fn_iat_add_admin_menu_page'));
    }

    public function fn_iat_add_admin_menu_page()
    {
        /* add Image alt text menu page.  */
        $image_alt_text_menu_page = add_menu_page(
            esc_html(__('Image Alt Text', IMAGE_ALT_TEXT)),
            esc_html(__('Image Alt Text', IMAGE_ALT_TEXT)),
            'manage_options',
            'image-alt-text',
            array($this, 'fn_iat_image_alternative_text_handler'),
            'dashicons-format-image',
            4
        );

        /* css. */
        add_action('admin_print_styles-' . $image_alt_text_menu_page, array($this, 'fn_iat_image_alternative_text_css'));

        /* js. */
        add_action('admin_print_scripts-' . $image_alt_text_menu_page, array($this, 'fn_iat_image_alternative_text_js'));
    }

    public function fn_iat_image_alternative_text_css()
    {
        /* register. */
        wp_register_style('iat-bootstrap-css', plugins_url('/assets/css/bootstrap.min.css', dirname(__FILE__)), false, IAT_FILE_VERSION, 'all');
        wp_register_style('iat-datatable-css', plugins_url('/assets/css/datatable.min.css', dirname(__FILE__)), false, IAT_FILE_VERSION, 'all');
        wp_register_style('iat-admin-css', plugins_url('/assets/css/iat-admin.css', dirname(__FILE__)), false, IAT_FILE_VERSION, 'all');

        /* enqueue. */
        wp_enqueue_style('iat-bootstrap-css');
        wp_enqueue_style('iat-datatable-css');        
        wp_enqueue_style('iat-admin-css');        
    }

    public function fn_iat_image_alternative_text_js()
    {
        /* register. */
        wp_register_script('iat-bootstrap-js', plugins_url('/assets/js/bootstrap.min.js', dirname(__FILE__)), array('jquery'), IAT_FILE_VERSION, true);
        wp_register_script('iat-datatable-js', plugins_url('/assets/js/datatable.min.js', dirname(__FILE__)), array('jquery'), IAT_FILE_VERSION, true);
        wp_register_script('iat-admin-js', plugins_url('/assets/js/iat-admin.js', dirname(__FILE__)), array('jquery'), IAT_FILE_VERSION, true);

        /* enqueue. */
        wp_enqueue_script('iat-bootstrap-js');
        wp_enqueue_script('iat-datatable-js');        
        wp_enqueue_script('iat-admin-js');

        /* localize script for wat-admin-js */
        wp_localize_script('iat-admin-js', 'iat_obj', array('ajaxurl' => admin_url('admin-ajax.php'), 'admin_url' => admin_url()));
    }

    public function fn_iat_image_alternative_text_handler()
    {
        /* add Image alt text view  */
        if (file_exists(IAT_FILE_PATH . '/admin/iat-missing-alt-txt-media-list.php')) {
            include_once( IAT_FILE_PATH . '/admin/iat-missing-alt-txt-media-list.php' );
        }
    }
}

$iat_general = new iat_general();